/* This file contains some compile-time configuration options for MS Windows
 * systems when building using build.sh (MinGW, Cygwin).
 * config_win.h is generated from src/config_win.h.in by build.sh
 * For building using MSVC, you'll have to edit src/config_vc6.h manually
 * if you want anything else than the defaults.
 * For *nix systems, config_unix.h is used, which is generated by build.sh
 * from src/config_unix.h.in.
 */

#ifndef CONFIG_WIN_H_
#define CONFIG_WIN_H_

/* Directory where the UQM game data is located */
#define CONTENTDIR "../content/"

/* Directory where game data will be stored */
//#define USERDIR "../userdata/"
#define USERDIR "%APPDATA%/uqm/"

/* Directory where config files will be stored */
#define CONFIGDIR USERDIR

/* Directory where supermelee teams will be stored */
#define MELEEDIR "%UQM_CONFIG_DIR%/teams/"

/* Directory where save games will be stored */
#define SAVEDIR "%UQM_CONFIG_DIR%/save/"

/* Defined if words are stored with the most significant byte first */
#undef WORDS_BIGENDIAN

/* Defined if your system has readdir_r of its own */
#undef HAVE_READDIR_R

/* Defined if your system has setenv of its own */
#define HAVE_SETENV

/* Defined if your system has strupr of its own */
#define HAVE_STRUPR

/* Defined if your system has strcasecmp of its own */
#define HAVE_STRCASECMP_UQM
		// Not using "HAVE_STRCASECMP" as that conflicts with SDL.

/* Defined if your system has stricmp of its own */
#define HAVE_STRICMP

/* Defined if your system has getopt_long */
#define HAVE_GETOPT_LONG

/* Defined if your system has iswgraph of its own*/
#define HAVE_ISWGRAPH

/* Defined if your system has wchar_t of its own */
#define HAVE_WCHAR_T

/* Defined if your system has wint_t of its own */
#define HAVE_WINT_T

/* Defined if your system has _Bool of its own */
#define HAVE__BOOL

#endif  /* CONFIG_WIN_H_ */


